tinymce.PluginManager.requireLangPack('codemirror')

tinymce.PluginManager.add('codemirror', function(editor, url) {
    function showSourceEditor() {
        editor.focus()
        editor.selection.collapse(true)

        editor.insertContent('<span id="CmCaReT"></span>')

        var buttonsConfig = [
                {
                    type: 'cancel',
                    text: 'Cancel',
                    name: 'codemirrorCancel'
                },
                {
                    type: 'custom',
                    text: 'Save',
                    name: 'codemirrorOk',
                    primary: true
                }
            ];

        var ww = 1024 * getBaseSize();

        if (ww > ($(window).width() * 0.9)) { ww = $(window).width() * 0.9; }

        var wh = 800 * getBaseSize();
        if (wh > ($(window).height() * 0.85)) { wh = $(window).height() * 0.85; }

        var config = {
            title: 'HTML source code',
            url: url + '/editor.html',
            width: ww,
            height: wh,
            buttons: buttonsConfig
        }

        config.onAction = function (dialogApi, actionData) {
            if (actionData.name === 'codemirrorOk') {
                var doc = document.querySelectorAll('.tox-dialog__body-iframe iframe')[0];
                doc.contentWindow.submit();
                codewindow.close();
            }
        }

        var codewindow = editor.windowManager.openUrl(config);

    }

    editor.ui.registry.addButton('code', {
        icon: 'sourcecode',
        title: 'Source code',
        tooltip: 'Source code',
        onAction: showSourceEditor
    });

    editor.ui.registry.addMenuItem('code', {
        icon: 'sourcecode',
        text: 'Source code',
        onAction: showSourceEditor,
        context: 'tools'
    });

});
